/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.client.gui.WindowBuildBuilding;
import com.minecolonies.coremod.client.gui.WindowHutAllInventory;
import com.minecolonies.coremod.client.gui.WindowHutNameEntry;
import com.minecolonies.coremod.client.gui.WindowInfo;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildRequestMessage;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractWindowModuleBuilding<B extends IBuildingView>
extends AbstractModuleWindow {
    protected final B building;
    private final Text title;
    private final Button buttonBuild;

    public AbstractWindowModuleBuilding(B building, String resource) {
        super((IBuildingView)building, resource);
        this.building = building;
        this.registerButton("build", this::buildClicked);
        this.registerButton("info", this::infoClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("editName", this::editName);
        this.registerButton("allinventory", this::allInventoryClicked);
        this.title = (Text)this.findPaneOfTypeByID("name", Text.class);
        this.buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        Button buttonInfo = (Button)this.findPaneOfTypeByID("info", Button.class);
        if (buttonInfo != null) {
            buttonInfo.setVisible(I18n.func_188566_a((String)("com.minecolonies.coremod.info." + building.getSchematicName() + ".0")));
        }
    }

    private void editName() {
        WindowHutNameEntry window = new WindowHutNameEntry((IBuildingView)this.building);
        window.open();
    }

    private void infoClicked() {
        WindowInfo window = new WindowInfo((IBuildingView)this.building);
        window.open();
    }

    private void allInventoryClicked() {
        WindowHutAllInventory window = new WindowHutAllInventory((IBuildingView)this.building, (Window)this);
        window.open();
    }

    private void buildClicked() {
        String buttonLabel = this.buttonBuild.getTextAsString();
        if (buttonLabel.equalsIgnoreCase(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.cancelbuild", (Object[])new Object[0])) || buttonLabel.equalsIgnoreCase(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.cancelupgrade", (Object[])new Object[0]))) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.BUILD, BlockPos.field_177992_a));
        } else if (buttonLabel.equalsIgnoreCase(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.cancelrepair", (Object[])new Object[0]))) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.REPAIR, BlockPos.field_177992_a));
        } else if (buttonLabel.equalsIgnoreCase(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.canceldeconstruction", (Object[])new Object[0]))) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.REMOVE, BlockPos.field_177992_a));
        } else {
            WindowBuildBuilding window = new WindowBuildBuilding(this.building.getColony(), (IBuildingView)this.building);
            window.open();
        }
    }

    private void inventoryClicked() {
        Network.getNetwork().sendToServer(new OpenInventoryMessage((IBuildingView)this.building));
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateButtonBuild((IBuildingView)this.building);
    }

    public abstract String getBuildingName();

    private void updateButtonBuild(IBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.cancelbuild", (Object[])new Object[0]));
            } else {
                this.buttonBuild.setText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.cancelupgrade", (Object[])new Object[0]));
            }
        } else if (buildingView.isRepairing()) {
            this.buttonBuild.setText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.cancelrepair", (Object[])new Object[0]));
        } else if (buildingView.isDeconstructing()) {
            this.buttonBuild.setText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.canceldeconstruction", (Object[])new Object[0]));
        } else {
            this.buttonBuild.setText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.buildrepair", (Object[])new Object[0]));
        }
    }

    public void onOpened() {
        String name;
        super.onOpened();
        this.setPage(false, 0);
        String string = name = this.building.getCustomName().isEmpty() ? LanguageHandler.format((String)this.getBuildingName(), (Object[])new Object[0]) : this.building.getCustomName();
        if (this.switchView != null && this.switchView.getID().equals("switchpageActions")) {
            this.title.setText(name);
            ((Text)this.findPaneOfTypeByID("level", Text.class)).setText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townhall.buildingLevel", (Object[])new Object[0]) + ": " + this.buildingView.getBuildingLevel());
        } else if (this.title != null) {
            this.title.setText(name + " " + this.buildingView.getBuildingLevel());
        }
    }
}

